class XCrade_Damage extends TournamentPickup;

var Weapon UDamageWeapon;
var sound ExtraFireSound;
var sound EndFireSound;
var int FinalCount;

singular function UsedUp()
{
	if ( UDamageWeapon != None )
	{
		UDamageWeapon.SetDefaultDisplayProperties();
		if ( UDamageWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(UDamageWeapon).Affector = None;
	}
	if ( Owner != None )
	{
		if ( Owner.bIsPawn )
		{
			if ( !Pawn(Owner).bIsPlayer || (Pawn(Owner).PlayerReplicationInfo.HasFlag == None) )
			{
				Owner.AmbientGlow = Owner.Default.AmbientGlow;
				Owner.LightType = LT_None;
			}
			Pawn(Owner).DamageScaling = 1.0;
		}
		bActive = false;
		if ( Owner.Inventory != None )
		{
			Owner.Inventory.SetOwnerDisplay();
			Owner.Inventory.ChangedWeapon();
		}
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogItemDeactivate(Self, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogItemDeactivate(Self, Pawn(Owner));
	}
	Destroy();
}

simulated function FireEffect()
{
	if ( (TimerRate - TimerCounter < 5) && (Level.NetMode != NM_Client) )
		Pawn(Owner).Weapon.PlayOwnedSound(EndFireSound, SLOT_Interact, 8);
	else 
		Pawn(Owner).Weapon.PlayOwnedSound(ExtraFireSound, SLOT_Interact, 8);
}

function SetOwnerLighting()
{
	if ( Owner.bIsPawn && Pawn(Owner).bIsPlayer
		&& (Pawn(Owner).PlayerReplicationInfo.HasFlag != None) ) 
		return;
	Owner.AmbientGlow = 254; 
	Owner.LightEffect=LE_NonIncidence;
	Owner.LightBrightness=64;
	Owner.LightHue=85;
	Owner.LightRadius=24;
	Owner.LightSaturation=64;
	Owner.LightType=LT_Steady;
	Owner.LightEffect=LE_FastWave;
}

function SetUDamageWeapon()
{
	if ( !bActive )
		return;

	SetOwnerLighting();

	// Make old weapon normal again.
	if ( UDamageWeapon != None )
	{
		UDamageWeapon.SetDefaultDisplayProperties();
		if ( UDamageWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(UDamageWeapon).Affector = None;
	}
		
	UDamageWeapon = Pawn(Owner).Weapon;
	// Make new weapon cool.
	if ( UDamageWeapon != None )
	{
		if ( UDamageWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(UDamageWeapon).Affector = self;
		if ( Level.bHighDetailMode )
			UDamageWeapon.SetDisplayProperties(ERenderStyle.STY_Translucent, 
									 FireTexture'UnrealShare.Belt_fx.UDamageFX',
									 true,
									 true);
		else
			UDamageWeapon.SetDisplayProperties(ERenderStyle.STY_Normal, 
							 FireTexture'UnrealShare.Belt_fx.UDamageFX',
							 true,
							 true);
	}
}

//
// Player has activated the item, pump up their damage.
//
state Activated
{
	function Timer()
	{
		if ( Charge > 0 )
		{
			SetTimer(1.0, true);
			if (Charge == 1 || Charge == 2 || Charge == 3 || Charge == 4 || Charge == 5 )
			Owner.PlaySound(DeActivateSound,, 8);
			Charge--;
			return;
		}
		UsedUp();
	}

	function SetOwnerDisplay()
	{
		if( Inventory != None )
			Inventory.SetOwnerDisplay();

		SetUDamageWeapon();
	}

	function ChangedWeapon()
	{
		if( Inventory != None )
			Inventory.ChangedWeapon();

		SetUDamageWeapon();
	}

	function EndState()
	{
		UsedUp();
	}

	function BeginState()
	{
		bActive = true;
		SetTimer(1.0, true);
		Owner.PlaySound(ActivateSound);	
		SetOwnerLighting();
		Pawn(Owner).DamageScaling = 3.0;
		SetUDamageWeapon();	
	}
}

defaultproperties
{
     ExtraFireSound=Sound'Botpack.Pickups.AmpFire'
     EndFireSound=Sound'Botpack.Pickups.AmpFire2b'
     FinalCount=5
     bAutoActivate=True
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="Woot! Your damage will now be trippled!"
     ItemName="XCrade"
     PickupViewMesh=Mesh'MHXv3.XCrade'
     Charge=90
     MaxDesireability=2.500000
     PickupSound=Sound'Botpack.Pickups.AmpPickup'
     DeActivateSound=Sound'Botpack.Pickups.AmpOut'
     Icon=Texture'Botpack.Icons.I_UDamage'
     RemoteRole=ROLE_DumbProxy
     Texture=Texture'MHXv3.Crades.crade4'
     Mesh=Mesh'MHXv3.XCrade'
}
